/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.repository;

import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.maven.cli.configuration.SettingsXmlConfigurationProcessor;
import org.netbeans.modules.maven.indexer.api.QueryField;
import org.netbeans.modules.maven.indexer.api.RepositoryIndexer;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.repository.Bundle;
import org.netbeans.modules.maven.repository.FindInRepoPanel;
import org.netbeans.modules.maven.repository.FindResultsNode;
import org.netbeans.modules.maven.repository.RepositoryNode;
import org.netbeans.modules.maven.repository.register.RepositoryRegisterUI;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.Union2;

public final class M2RepositoryBrowser
extends AbstractNode {
    private static final RequestProcessor RP = new RequestProcessor(M2RepositoryBrowser.class);
    static final String NAME = "M2RepositoryBrowser";
    static final String ICON_PATH = "org/netbeans/modules/maven/repository/MavenRepoBrowser.png";
    private static final List<QueryRequest> searches = new ArrayList<QueryRequest>();
    private static final ChangeSupport cs = new ChangeSupport(M2RepositoryBrowser.class);

    private M2RepositoryBrowser() {
        super(Children.create((ChildFactory)new RootNodes(), (boolean)true));
        this.setName(NAME);
        this.setDisplayName(Bundle.CTL_M2RepositoryBrowserTopComponent2(RepositoryPreferences.isIndexRepositories() ? "" : Bundle.CTL_M2RepositoriesDisabled()));
        this.setShortDescription(Bundle.HINT_M2RepositoryBrowserTopComponent());
        this.setIconBaseWithExtension(ICON_PATH);
        NbPreferences.root().node("org/netbeans/modules/maven/nexus/indexing").addPreferenceChangeListener(new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent evt) {
                if ("createIndex".equals(evt.getKey())) {
                    M2RepositoryBrowser.this.setDisplayName(Bundle.CTL_M2RepositoryBrowserTopComponent2(RepositoryPreferences.isIndexRepositories() ? "" : Bundle.CTL_M2RepositoriesDisabled()));
                }
            }
        });
    }

    public Action[] getActions(boolean context) {
        return new Action[]{new SearchAction(), new AddAction()};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void remove(QueryRequest search) {
        List<QueryRequest> list = searches;
        synchronized (list) {
            searches.remove(search);
        }
        cs.fireChange();
    }

    public static void addChangeListener(ChangeListener l) {
        cs.addChangeListener(l);
    }

    public static void removeChangeListener(ChangeListener l) {
        cs.removeChangeListener(l);
    }

    private static class RootNodes
    extends ChildFactory.Detachable<Union2<RepositoryInfo, QueryRequest>>
    implements ChangeListener,
    FileChangeListener {
        boolean addNotifyCalled = false;

        private RootNodes() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean createKeys(List<Union2<RepositoryInfo, QueryRequest>> toPopulate) {
            for (RepositoryInfo info : RepositoryPreferences.getInstance().getRepositoryInfos()) {
                toPopulate.add((Union2<RepositoryInfo, QueryRequest>)Union2.createFirst((Object)info));
            }
            List<QueryRequest> list = searches;
            synchronized (list) {
                for (QueryRequest search : searches) {
                    toPopulate.add((Union2<RepositoryInfo, QueryRequest>)Union2.createSecond((Object)search));
                }
            }
            return true;
        }

        protected Node createNodeForKey(Union2<RepositoryInfo, QueryRequest> key) {
            if (key.hasFirst()) {
                return new RepositoryNode((RepositoryInfo)key.first());
            }
            return new FindResultsNode((QueryRequest)key.second());
        }

        protected void addNotify() {
            RepositoryPreferences.getInstance().addChangeListener((ChangeListener)this);
            FileUtil.addFileChangeListener((FileChangeListener)this, (File)SettingsXmlConfigurationProcessor.DEFAULT_USER_SETTINGS_FILE);
            M2RepositoryBrowser.addChangeListener(this);
            this.addNotifyCalled = true;
        }

        protected void removeNotify() {
            RepositoryPreferences.getInstance().removeChangeListener((ChangeListener)this);
            M2RepositoryBrowser.removeChangeListener(this);
            if (this.addNotifyCalled) {
                try {
                    FileUtil.removeFileChangeListener((FileChangeListener)this, (File)SettingsXmlConfigurationProcessor.DEFAULT_USER_SETTINGS_FILE);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                this.addNotifyCalled = false;
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.refresh(false);
        }

        public void fileFolderCreated(FileEvent fe) {
        }

        public void fileDataCreated(FileEvent fe) {
            this.refresh(false);
        }

        public void fileChanged(FileEvent fe) {
            this.refresh(false);
        }

        public void fileDeleted(FileEvent fe) {
            this.refresh(false);
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.refresh(false);
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }
    }

    private class SearchAction
    extends AbstractAction {
        SearchAction() {
            super(Bundle.LBL_REPO_Find());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            FindInRepoPanel pnl = new FindInRepoPanel();
            pnl.getAccessibleContext().setAccessibleDescription(Bundle.TIT_Find_In_Repositories());
            DialogDescriptor dd = new DialogDescriptor((Object)pnl, Bundle.TIT_Find_In_Repositories());
            pnl.attachDesc(dd);
            Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
            if (ret == DialogDescriptor.OK_OPTION) {
                QueryRequest request = new QueryRequest(pnl.getQuery(), RepositoryPreferences.getInstance().getRepositoryInfos());
                List<QueryRequest> list = searches;
                synchronized (list) {
                    searches.add(request);
                }
                cs.fireChange();
            }
        }
    }

    private static class AddAction
    extends AbstractAction {
        AddAction() {
            super(Bundle.ACT_Add_Repo());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RepositoryRegisterUI rrui = new RepositoryRegisterUI();
            rrui.getAccessibleContext().setAccessibleDescription(Bundle.LBL_Add_Repo());
            DialogDescriptor dd = new DialogDescriptor((Object)rrui, Bundle.LBL_Add_Repo());
            dd.setClosingOptions(new Object[]{rrui.getButton(), DialogDescriptor.CANCEL_OPTION});
            dd.setOptions(new Object[]{rrui.getButton(), DialogDescriptor.CANCEL_OPTION});
            Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
            if (rrui.getButton() == ret) {
                RepositoryInfo info;
                try {
                    info = rrui.getRepositoryInfo();
                }
                catch (URISyntaxException x) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)x.getLocalizedMessage(), 0));
                    return;
                }
                RepositoryPreferences.getInstance().addOrModifyRepositoryInfo(info);
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        RepositoryIndexer.indexRepo((RepositoryInfo)info);
                    }
                });
            }
        }
    }

    static class QueryRequest {
        final List<QueryField> fields;
        final List<RepositoryInfo> infos;

        QueryRequest(List<QueryField> fields, List<RepositoryInfo> infos) {
            this.fields = fields;
            this.infos = infos;
        }
    }
}

